package com.bxm.egg.user.info.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.component.bus.annotations.EventBusSubscriber;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.event.UserInfoChangeEvent;
import com.bxm.egg.user.info.event.UserNickNameAndHeadImgChangeEvent;
import com.bxm.egg.user.integration.IMIntegrationService;
import com.bxm.egg.user.integration.SixEnjoyUserIntegrationService;
import com.bxm.sync.facade.param.UpdateUserInfoParam;
import com.bxm.sync.facade.service.SixEnjoyUserFacadeService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * 用户信息改变监听器
 *
 * @author wzy
 * @version 1.0
 * @date 2021/10/14 9:59 上午
 */
@Slf4j
@Component
@AllArgsConstructor
public class UserInfoChangeListener {

    private UserInfoCacheService userInfoCacheService;

    private IMIntegrationService imIntegrationService;

    private SixEnjoyUserIntegrationService sixEnjoyUserIntegrationService;

    @EventBusSubscriber
    @Async
    public void userInfoChangeEvent(UserInfoChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("监听到用户信息改变事件，事件内容: {}", JSON.toJSONString(event));
        }
        //清空指定用户缓存
        userInfoCacheService.clearUserCache(event.getUserId());
    }

    @EventBusSubscriber
    @Async
    public void changeNickNameAndHeadImg(UserNickNameAndHeadImgChangeEvent event) {
        // 同步IM中的昵称和头像
        imIntegrationService.syncUser(event.getUserId(), event.getNickName(), event.getHeadImg());

        sixEnjoyUserIntegrationService.updateUserHeadImgOrNickname(UpdateUserInfoParam.builder()
                .userId(event.getUserId())
                .headImg(event.getHeadImg())
                .nickname(event.getNickName())
                .build());

        userInfoCacheService.clearUserBriefCache(event.getUserId());
    }
}