package com.bxm.egg.user.invite;

import com.bxm.egg.user.invite.processor.DefaultInviteTypeProcessor;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 邀请类型处理器管理类
 * @author liujia
 * @date 2020/05/11 15:32
 */
@Component
public class InviteTypeProcessorManager {
    private Map<String, InviteTypeProcessor> processorMap;

    private DefaultInviteTypeProcessor defaultProcessor;

    @Autowired
    public InviteTypeProcessorManager(List<InviteTypeProcessor> processors,
                                      DefaultInviteTypeProcessor defaultProcessor) {
        processorMap = Maps.newHashMap();

        if (null != processors) {
            processors.forEach(processor -> processorMap.put(processor.support().getName(), processor));
        }
        this.defaultProcessor = defaultProcessor;
    }

    public InviteTypeProcessor obtain(String inviteType) {
        return processorMap.getOrDefault(inviteType, defaultProcessor);
    }
}
