package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.utils.MaxLengthStringBuilder;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 通过新闻邀请用户的处理逻辑
 *
 * @author liujia
 * @date 2020/05/11 15:45
 */
@Component
public class NewsInviteTypeProcessor extends AbstractInviteTypeProcessor {

    private final NewsIntegrationService newsIntegrationService;

    @Autowired
    public NewsInviteTypeProcessor(NewsIntegrationService newsIntegrationService) {
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.NEWS;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank(inviteHistory.getRelationTitle())) {
            return defaultInviteMsg;
        }

        return MaxLengthStringBuilder.builder(defaultColumnWidth)
                .appendImmutable("分享的《")
                .appendDynamic(inviteHistory.getRelationTitle())
                .appendImmutable("》新闻")
                .build();
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return StringUtils.EMPTY;
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}
