package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.dto.TopicFacadeVO;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.utils.MaxLengthStringBuilder;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 论坛话题分享进行的邀请
 *
 * @author liujia
 * @date 2020/05/12 14:14
 */
@Component
public class TopicInviteTypeProcessor extends AbstractInviteTypeProcessor {

    private final NewsIntegrationService newsIntegrationService;

    @Autowired
    public TopicInviteTypeProcessor(NewsIntegrationService newsIntegrationService) {
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return StringUtils.EMPTY;
        }

        TopicFacadeVO topic = newsIntegrationService.getTopicById(context.getRelationId());

        if (StringUtils.isBlank(topic.getTitle())) {
            return StringUtils.EMPTY;
        }

        return topic.getTitle();
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.TOPIC;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank(inviteHistory.getRelationTitle())) {
            return defaultInviteMsg;
        }
        return MaxLengthStringBuilder.builder(defaultColumnWidth)
                .appendImmutable("分享的《")
                .appendDynamic(inviteHistory.getRelationTitle())
                .appendImmutable("》话题")
                .build();
    }
}
