package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import org.springframework.stereotype.Component;

/**
 * 福利VIP卡邀请处理（发生购买的情况下）
 *
 * @author liujia
 * @date 2020/05/11 16:54
 */
@Component
public class WelfareVipInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.WELFARE_VIP;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "的蛋蛋佳开卡邀请";
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "蛋蛋佳开卡";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}
