package com.bxm.egg.user.location;

import com.bxm.egg.user.constant.UserLocationTypeEnum;
import com.bxm.egg.user.model.dto.location.LocationSwitchDTO;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.param.UserHomeTownParam;
import com.bxm.egg.user.model.param.location.LocationSwitchParam;

/**
 * 用户定位信息service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 11:09 上午
 */
public interface UserLocationService {

    /**
     * 根据用户id获取用户的定位信息
     *
     * @param userId 用户id
     * @return 用户的定位信息
     */
    UserLocationEntity getUserLocationByUserId(Long userId);

    /**
     * 更新用户的家乡信息
     *
     * @param userHomeTownParam 入参
     * @return 影响行数
     */
    int updateUserHometownInfo(UserHomeTownParam userHomeTownParam);


    /**
     * 更新用户的定位信息
     *
     * @param userId       用户id
     * @param locationCode 地区编码
     * @param locationName 地区名称
     * @param locationType 定位方式
     * @return 影响行数
     */
    int updateUserLocationInfo(Long userId,
                               String locationCode,
                               String locationName,
                               UserLocationTypeEnum locationType);


    /**
     * 更新用户定位信息通过
     *
     * @param userId             用户id
     * @param userLocationEntity 更新用户信息
     * @return 影响行数
     */
    int updateUserLocationInfo(Long userId,
                               UserLocationEntity userLocationEntity);


    /**
     * 根据客户端上报的客户端本地存储code和第三方获取到的定位code，进行用户最终定位的获取
     * 如果用户属于强制切换列表中，则返回强制切换的信息
     * 如果用户上一次的定位code不为空，则直接返回上一次的定位code，强制切换
     * 如果数据库存储的用户定位信息为空，则根据第三方code进行获取城市信息，获取到则返回信息，强制切换
     *
     * @param param 获取需要切换的城市参数
     * @return 切换城市的信息 是否强制切换
     */
    LocationSwitchDTO locationSwitch(LocationSwitchParam param);
}