package com.bxm.egg.user.location.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.bus.config.ComponentEventBus;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.constant.UserLocationTypeEnum;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.location.UserInternalService;
import com.bxm.egg.user.location.event.UserLocationChangeEvent;
import com.bxm.egg.user.location.event.UserLocationReportEvent;
import com.bxm.egg.user.login.UserParamCheckService;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.param.ChangeLocationParam;
import com.bxm.egg.user.model.param.UserLocationParam;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

@Slf4j
@Service
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class UserInternalServiceImpl implements UserInternalService {

    private LocationIntegrationService locationIntegrationService;

    private CommonProperties commonProperties;

    private UserParamCheckService userParamCheckService;

    private UserStatisticsService userStatisticsService;

    private UserAccountService userAccountService;

    private UserProperties userProperties;

    @Override
    public LocationDTO doPostingLocation(ChangeLocationParam changeLocationParam, String ip) {
        Message message = userParamCheckService.checkPostLocationParam(changeLocationParam.getCode(),
                changeLocationParam.getUserId());
        if (!message.isSuccess()) {
            log.error(message.getLastMessage());
        }

        if (null == changeLocationParam.getCode()) {
            changeLocationParam.setCode(commonProperties.getLocationCode());
        }

        LocationDTO locationDTO = locationIntegrationService.getLocationByGeocode(changeLocationParam.getCode());

        if (null != changeLocationParam.getUserId()) {
            UserStatisticsEntity userStatisticsEntity = userStatisticsService.selectUserStatisticsByUserId(changeLocationParam.getUserId());
            locationDTO.setPublishPostNum(userStatisticsEntity == null ? 0 : userStatisticsEntity.getPostNum());

            String areaCode = locationDTO.getCode();

            //如果地区等级为3，也就是区县，则通知六享
            if (Objects.equals(locationDTO.getLevel(), (byte) 3)) {
                areaCode = locationDTO.getCode();
                areaCode = com.bxm.newidea.component.tools.StringUtils.substring(areaCode, 0, 4);
                areaCode = areaCode + "000000000000".substring(areaCode.length());
                if (userProperties.getUpdateSixEnjoyArea()) {
                    userAccountService.updateSixEnjoyUserArea(changeLocationParam.getUserId(), locationDTO);
                }
            }

            //更新用户地理位置以及其他操作
            ComponentEventBus.publishEvent(UserLocationChangeEvent.builder()
                    .areaCode(areaCode)
                    .areaName(locationDTO.getName())
                    .userId(changeLocationParam.getUserId())
                    .locationType(UserLocationTypeEnum.MANUAL)
                    .build());


        } else {
            locationDTO.setPublishPostNum(0);
        }

        return locationDTO;
    }

    @Override
    public Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam) {
        if (log.isDebugEnabled()) {
            log.debug("上报用户定位以及活跃信息:{}", JSON.toJSONString(userLocationParam));
        }

        LocationDTO locationByGeocode = locationIntegrationService.getLocationByGeocode(userLocationParam.getCurrentAreaCode());

        if (Objects.nonNull(userLocationParam.getUserId()) &&
                StringUtils.isNotBlank(userLocationParam.getLatitude()) &&
                StringUtils.isNotBlank(userLocationParam.getLongitude())) {

            //上报用户地理位置
            ComponentEventBus.publishEvent(UserLocationReportEvent.builder()
                    .areaCode(locationByGeocode.getCode())
                    .areaName(locationByGeocode.getName())
                    .lat(new BigDecimal(userLocationParam.getLatitude()))
                    .lng(new BigDecimal(userLocationParam.getLongitude()))
                    .userId(userLocationParam.getUserId())
                    .build());
        }

        return true;
    }
}
