package com.bxm.egg.user.location.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.component.bus.annotations.EventBusSubscriber;
import com.bxm.egg.user.event.LocationActionEvent;
import com.bxm.egg.user.event.UserActionEvent;
import com.bxm.egg.user.integration.UserSyncIntegrationService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.location.event.UserLocationChangeEvent;
import com.bxm.egg.user.mapper.UserLocationHistoryMapper;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.entity.UserLocationHistoryEntity;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.eventbus.EventBus;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Date;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * 用户位置改变监听器
 *
 * @author wzy
 * @version 1.0
 * @date 2021/10/14 9:59 上午
 */
@Slf4j
@Component
@AllArgsConstructor
public class UserLocationChangeListener {

    private UserLocationHistoryMapper userLocationHistoryMapper;

    private UserLocationService userLocationService;

    private EventBus userActionEventBus;

    private UserSyncIntegrationService userSyncIntegrationService;

    @EventBusSubscriber
    @Async
    public void userLocationInfoChangeEvent(UserLocationChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("监听到用户位置改变事件，事件内容: {}", JSON.toJSONString(event));
        }

        Long userId = event.getUserId();
        String areaCode = event.getAreaCode();
        String areaName = event.getAreaName();
        //查找用户原来的地理位置
        UserLocationEntity userLocationInfo = this.userLocationService.getUserLocationByUserId(userId);

        if (StringUtils.equals(userLocationInfo.getLocationCode(), areaCode)) {
            return;
        }

        if (StringUtils.isNotBlank(event.getAreaCode())) {
            String oldLocationCode = userLocationInfo.getLocationCode();

            userLocationInfo.setLocationCode(areaCode);
            userLocationInfo.setLocationName(areaName);

            //1.更新用户信息
            this.userLocationService.updateUserLocationInfo(userId,
                    areaCode,
                    areaName,
                    event.getLocationType());

            //2.位置历史表新增
            UserLocationHistoryEntity userLocationHistory = new UserLocationHistoryEntity();
            userLocationHistory.setAddTime(new Date());
            userLocationHistory.setId(SequenceHolder.nextLongId());
            userLocationHistory.setLocationCode(areaCode);
            userLocationHistory.setUserId(userId);
            userLocationHistory.setLat(event.getLat());
            userLocationHistory.setLng(event.getLng());
            userLocationHistoryMapper.insert(userLocationHistory);

            //4、通知新闻服务
            userSyncIntegrationService.changeLocation(userId, areaCode);


        } else {
            log.warn("用户位置信息变更失败，用户ID：{},变更后的位置:{},用户的当前位置：{}",
                    userId,
                    areaCode,
                    userLocationInfo.getLocationCode());
        }
    }
}