package com.bxm.egg.user.location.rule;

import com.bxm.egg.user.constant.OrderConstant;
import com.bxm.egg.user.constant.SwitchType;
import com.bxm.egg.user.constant.UserBizConfigProperties;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.location.context.LocationSwitchContext;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import static com.bxm.egg.user.constant.LogicGroup.LOCATION_SWITCH_RULE;


/**
 * 如果用户存在历史定位，则优先采用历史定位
 *
 * @author liujia
 * @date 10/29/21 10:01 AM
 **/
@RuleBean(group = LOCATION_SWITCH_RULE)
@AllArgsConstructor
@Slf4j
public class ActualLocationRule implements IRule<LocationSwitchContext> {

    private final UserBizConfigProperties userBizConfigProperties;

    private final LocationIntegrationService locationIntegrationService;

    @Override
    public boolean apply(LocationSwitchContext context) {
        String thirdpartyCode = context.getParam().getThirdpartyCode();
        if (StringUtils.isBlank(thirdpartyCode)) {
            log.info("用户[{}]未开启定位，不进行真实定位解析.编码：{}", context.getUserId(), thirdpartyCode);
            return true;
        }

        if (userBizConfigProperties.getLocationToCity()) {
            thirdpartyCode = StringUtils.substring(thirdpartyCode, 0, 4);
            thirdpartyCode = thirdpartyCode + "000000000000".substring(thirdpartyCode.length());
        }

        LocationDTO locationDTO = locationIntegrationService.getLocationByGeocode(thirdpartyCode);
        if (null == locationDTO || StringUtils.isBlank(locationDTO.getCode())) {
            log.info("真实定位[{}]不匹配，不予处理", thirdpartyCode);
            return true;
        }

        context.setFinalAreaCode(locationDTO.getCode());
        context.setFinalSwitchType(SwitchType.FORCE_SWITCH);
        context.setMatchRuleClass(this.getClass());
        return false;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
