package com.bxm.egg.user.location.rule;

import com.bxm.egg.user.constant.OrderConstant;
import com.bxm.egg.user.constant.SwitchType;
import com.bxm.egg.user.facade.bo.UserLocationFullInfoBO;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.location.context.LocationSwitchContext;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

import static com.bxm.egg.user.constant.LogicGroup.LOCATION_SWITCH_RULE;
import static java.util.Objects.isNull;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * 如果用户存在历史定位，则优先采用历史定位
 *
 * @author liujia
 * @date 10/29/21 10:01 AM
 **/
@RuleBean(group = LOCATION_SWITCH_RULE)
@AllArgsConstructor
@Slf4j
public class HistoryLocationRule implements IRule<LocationSwitchContext> {

    private UserLocationService userLocationService;

    @Override
    public boolean apply(LocationSwitchContext context) {
        UserLocationEntity userLocationEntity = userLocationService.getUserLocationByUserId(context.getUserId());

        if (isNull(userLocationEntity) || isBlank(userLocationEntity.getLocationCode())) {
            // 继续查找下一个
            return true;
        }

        if (Objects.equals(userLocationEntity.getLocationType(), 0)
                || Objects.equals(userLocationEntity.getLocationType(), 3)) {
            // 用户使用的默认定位，重新进行定位
            log.info("用户[{}]使用的默认定位，重新进行定位", context.getUserId());
            return true;
        }

        context.setFinalSwitchType(SwitchType.FORCE_SWITCH);
        context.setFinalAreaCode(userLocationEntity.getLocationCode());
        context.setMatchRuleClass(this.getClass());
        return false;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
