package com.bxm.egg.user.location.rule;

import com.bxm.egg.user.constant.OrderConstant;
import com.bxm.egg.user.location.context.LocationSwitchContext;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import lombok.AllArgsConstructor;

import static com.bxm.egg.user.constant.LogicGroup.LOCATION_SWITCH_RULE;

/**
 * 如果用户有邀请人，则优先匹配邀请人所在的定位
 *
 * @author liujia
 * @date 10/29/21 10:01 AM
 **/
@RuleBean(group = LOCATION_SWITCH_RULE)
@AllArgsConstructor
public class InviteLocationRule implements IRule<LocationSwitchContext> {

    @Override
    public boolean apply(LocationSwitchContext context) {
        // 暂时没做邀请人的逻辑
        return true;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
