package com.bxm.egg.user.login;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.param.login.LoginParam;
import com.bxm.sync.facade.param.UpdateUserPwdParam;

/**
 * 后续异步处理
 *
 * @author lowi
 * @date 2021/11/25 20:05
 */

public interface AfterAsyncHandlerService {

    /**
     * 处理用户迁移数据
     *
     * @param userId            用户id
     * @param param             登录参数
     * @param userLoginTypeEnum 登录类型
     * @param resultDTO         登录结果
     */
    <T extends LoginParam> void handleUserEggMigration(Long userId, UserLoginTypeEnum userLoginTypeEnum, T param,
                                                       LoginResultDTO resultDTO);

    /**
     * 同步用户密码到六享
     */
    void syncUserPwdToSixEnjoy(UpdateUserPwdParam updateUserPwdParam);
}
