package com.bxm.egg.user.login.impl;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.login.UserLogService;
import com.bxm.egg.user.mapper.UserLoginHistoryMapper;
import com.bxm.egg.user.mapper.UserRegisterLogMapper;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserLoginHistoryEntity;
import com.bxm.egg.user.model.entity.UserRegisterLogEntity;
import com.bxm.egg.user.model.param.login.LoginParam;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/16 10:21 上午
 */
@Slf4j
@Service
public class UserLogServiceImpl implements UserLogService {

    @Resource
    private UserRegisterLogMapper userRegisterLogMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private UserLoginHistoryMapper loginHistoryMapper;

    @Override
    @Async
    public void recordRegisterLog(UserInfoEntity newUser, LoginParam param) {
        UserRegisterLogEntity userRegisterLogEntity = new UserRegisterLogEntity();

        userRegisterLogEntity.setChannel(param.getChnl());
        userRegisterLogEntity.setId(sequenceCreater.nextLongId());
        userRegisterLogEntity.setLoginIp(param.getRequestIp());
        userRegisterLogEntity.setPlatform(param.getPlatform());
        userRegisterLogEntity.setUserId(newUser.getId());

        userRegisterLogMapper.insert(userRegisterLogEntity);
    }

    @Override
    @Async
    public void recordLoginLog(LoginParam loginParam, LoginResultDTO resultDTO,
                               UserLoginTypeEnum userLoginTypeEnum) {
        UserLoginHistoryEntity userLoginHistoryEntity = new UserLoginHistoryEntity();

        userLoginHistoryEntity.setId(sequenceCreater.nextLongId());
        userLoginHistoryEntity.setUserId(resultDTO.getUserId());
        userLoginHistoryEntity.setLoginType(userLoginTypeEnum.name());
        userLoginHistoryEntity.setLoginIp(loginParam.getRequestIp());
        userLoginHistoryEntity.setEquipmentId(loginParam.getDevcId());
        userLoginHistoryEntity.setFirstLogin(resultDTO.getFirstLogin() ? 1 : 0);
        userLoginHistoryEntity.setLoginTime(LocalDateTime.now());
        userLoginHistoryEntity.setPlatform(loginParam.getPlatform());
        userLoginHistoryEntity.setClientChannel(loginParam.getChnl());

        loginHistoryMapper.insert(userLoginHistoryEntity);

    }
}