/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.egg.user.login.protocal;

import com.bxm.egg.user.mapper.UserMapper;
import com.bxm.egg.user.model.dto.ProtocalInfoStrategyDTO;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.enums.ProtocalTypeEnum;
import com.bxm.egg.user.invite.bind.BindInviteManager;
import com.bxm.egg.user.model.vo.User;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;

/**
 * @author : jieli.xu
 * @date 2020/7/14 10:22
 * 邀请粘贴板的内容处理
 */
@Component
@Slf4j
public class InviteProtocalMethod extends AbstractProtocalStrategy {

    @Resource
    private UserMapper userMapper;
    @Autowired
    private BindInviteManager bindInviteManager;

    @Override
    public Message doInvokeProtocal(ProtocalInfoStrategyDTO protocalParam) {
        Map<String, String> params = protocalParam.getParams();
        Long shareId = Long.parseLong(params.get("shareId"));
        if (Objects.equals(protocalParam.getUserClipboardParam().getUserId(), shareId)) {
            return Message.build(false);
        }
        //业务逻辑
        User user = userMapper.selectByUserId(protocalParam.getUserClipboardParam().getUserId());
        if (null == user || null != user.getInviteUserId()) {
            return null;
        }
        //绑定邀请关系
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.POSTERS_SHARE);
        userInviteBindDTO.setUserId(protocalParam.getUserClipboardParam().getUserId());
        userInviteBindDTO.setInviteUserId(shareId);
        UserInviteHistoryBean bean = bindInviteManager.bindInvite(userInviteBindDTO);
        return Message.build(null == bean);
    }

    @Override
    protected Integer getType() {
        return ProtocalTypeEnum.INVITE.getType();
    }
}
