package com.bxm.egg.user.login.strategy.support;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.UserBindWxParam;
import com.bxm.egg.user.model.param.login.ChuangLanLoginParam;
import com.bxm.egg.user.onekey.OneKeyService;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.Optional;

/**
 * 一键登录策略类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 8:02 下午
 */
@Slf4j
@Service
public class OneKeyLoginStrategy extends AbstractUserLoginStrategy<ChuangLanLoginParam> {

    @Resource
    private UserInfoService userInfoService;

    /**
     * 极光一键登录service
     */
    @Resource
    private OneKeyService oneKeyService;

    @Override
    protected Message beforeLoginAuthentication(ChuangLanLoginParam loginParam) {
        //验证token是否正确
        Message message = oneKeyService.checkToken(loginParam.getToken());

        if (!message.isSuccess()) {
            return message;
        }

        String phone = message.getParam("phone");
        loginParam.setPhone(phone);

        return Message.build(true);

    }

    @Override
    protected Long checkExists(ChuangLanLoginParam loginParam) {
        Optional<Long> userUnionIdExistOptional = userInfoService.userPhoneExist(loginParam.getPhone());

        return userUnionIdExistOptional.orElse(null);
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.ONE_KEY;
    }

    @Override
    protected boolean saveIdentity(ChuangLanLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(ChuangLanLoginParam loginParam, UserInfoEntity newUser) {
        newUser.setPhone(loginParam.getPhone());
        newUser.setUsername(loginParam.getPhone());
    }
}