package com.bxm.egg.user.login.strategy.support;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.constant.BizCodeConstant;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.model.bo.UserWechatBindBO;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.WechatAppLoginParam;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.Optional;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/8 10:52 上午
 */
@Slf4j
@Service
public class WechatLoginStrategy extends AbstractUserLoginStrategy<WechatAppLoginParam> {
    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;

    @Resource
    private UserWechatGrantService userWechatGrantService;


    @Override
    protected Message beforeLoginAuthentication(WechatAppLoginParam loginParam) {
        Optional<Long> userUnionIdExistOptional = userInfoService.userUnionIdExist(loginParam.getUnionId());

        log.warn("用户使用了新微信登录，请绑定手机号：{}", JSON.toJSONString(loginParam));

        if (!userUnionIdExistOptional.isPresent()) {
            Message resultMessage = Message.build(false, "您需要绑定手机号");
            resultMessage.setBizCode(BizCodeConstant.WX_LOGIN_NEED_BIND_PHONE);
            return resultMessage;
        }
        return Message.build(true);
    }

    @Override
    protected Long checkExists(WechatAppLoginParam loginParam) {
        Optional<Long> userUnionIdExistOptional = userInfoService.userUnionIdExist(loginParam.getUnionId());

        return userUnionIdExistOptional.orElse(null);
    }

    @Override
    protected Message afterLoginAuthentication(WechatAppLoginParam loginParam, LoginResultDTO resultDTO) {
        //用户是否绑定手机号
        if (resultDTO.getUserId() == -1L) {
            return buildNoBindPhoneResultMsg(resultDTO);
        }

        UserInfoEntity userInfoEntity = userInfoService.selectUserById(resultDTO.getUserId());

        if (Objects.isNull(userInfoEntity) || StringUtils.isEmpty(userInfoEntity.getPhone())) {
            buildNoBindPhoneResultMsg(resultDTO);
        }
        return Message.build(true);
    }

    private Message buildNoBindPhoneResultMsg(LoginResultDTO resultDTO) {
        log.warn("用户已经绑定微信，未绑定手机，绑定手机后才能继续登录,用户信息：{}", JSON.toJSONString(resultDTO));

        Message resultMessage = Message.build(false, "您需要绑定手机号");

        resultMessage.setBizCode(BizCodeConstant.WX_LOGIN_NEED_BIND_PHONE);
        return resultMessage;
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.WX;
    }

    @Override
    protected boolean saveIdentity(WechatAppLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(WechatAppLoginParam loginParam, UserInfoEntity newUser) {
    }

    /**
     * 处理新用户
     *
     * @param loginParam 登录参数
     * @return 处理返回信息
     */
    @Override
    protected Message handleNewUser(WechatAppLoginParam loginParam) {
        Message msg = Message.build(true);

        //这里属于一种正常情况为了兼容登录模板，返回一个假数据，因为新用户后置校验一定没有绑定手机号不会通过
        LoginResultDTO resultDTO = new LoginResultDTO();
        resultDTO.setUserId(-1L);

        return msg.addParam(LOGIN_RESULT_DTO, resultDTO);
    }
}