package com.bxm.egg.user.manage.chat.impl;

import com.bxm.egg.user.info.UserBaseInfoService;
import com.bxm.egg.user.manage.chat.UserManageChatAdminService;
import com.bxm.egg.user.mapper.manage.ManageUserChatRelationMapper;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.dto.manage.chat.ManageChatUserListDTO;
import com.bxm.egg.user.model.entity.manage.ManageUserChatRelationEntity;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lowi
 * @date 2022/2/16 16:10
 */
@AllArgsConstructor
@Service
@Slf4j
public class UserManageChatAdminServiceImpl implements UserManageChatAdminService {

    private final ManageUserChatRelationMapper manageUserChatRelationMapper;

    private final UserBaseInfoService userBaseInfoService;

    @Override
    public List<ManageChatUserListDTO> getChatUserListByAdmin(Long adminUserId) {

        List<ManageChatUserListDTO> manageChatUserListDTOS = new ArrayList<>();

        List<ManageUserChatRelationEntity> chatRelationEntities = manageUserChatRelationMapper.getListByAdminId(adminUserId);
        if (chatRelationEntities.isEmpty()) {
            return manageChatUserListDTOS;
        }
        List<UserBriefInfoDTO> userBriefInfoList = userBaseInfoService.getUserBriefInfoList(chatRelationEntities.stream().map(ManageUserChatRelationEntity::getUserId).collect(Collectors.toList()));

        userBriefInfoList.forEach(userBriefInfoDTO -> {
            manageChatUserListDTOS.add(ManageChatUserListDTO.builder()
                    .headImg(userBriefInfoDTO.getHeadImg())
                    .nickName(userBriefInfoDTO.getNickname())
                    .userId(userBriefInfoDTO.getUserId())
                    .build());
        });

        return manageChatUserListDTOS;
    }
}
