package com.bxm.egg.user.medal;

import com.bxm.egg.user.model.dto.medal.MedalMainPageSimpleDTO;
import com.bxm.egg.user.model.param.medal.SaveWearMedalParam;
import com.bxm.egg.user.model.vo.medal.*;
import com.bxm.newidea.component.bo.Message;

/**
 * 用户勋章相关接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/4 3:15 下午
 */
public interface UserMedalService {

    /**
     * 获取他人的勋章信息
     *
     * @param othersUserId 他人用户id
     * @return 他人勋章信息
     */
    OthersMedalVO getOthersMedal(Long othersUserId);

    /**
     * 获取我的勋章信息
     *
     * @param userId 用户id
     * @return 勋章信息
     */
    MyMedalVO getMyMedal(Long userId);

    /**
     * 获取成就勋章详情
     *
     * @param medalParentId 父勋章id
     * @param userId        用户id
     * @return 成就勋章详情信息
     */
    AchievementMedalDetailVO getAchievementMedalDetail(Long medalParentId, Long userId);

    /**
     * 获取定制勋章详情
     *
     * @param medalId 勋章id
     * @param userId  用户id
     * @return 定制勋章详情
     */
    CustomMedalDetailVO getCustomMedalDetail(Long medalId, Long userId);

    /**
     * 获取预览勋章信息
     *
     * @param userId 用户id
     * @return 预览勋章信息
     */
    PreviewMedalInfoVO getPreviewMedalInfo(Long userId);

    /**
     * 保存勋章佩戴信息
     *
     * @param param 佩戴勋章信息
     * @return 执行结果
     */
    Message saveWearMedal(SaveWearMedalParam param);


    /**
     * 获取主页勋章详情通过用户id
     *
     * @param userId 用户id
     * @return 主页勋章详情
     */
    MedalMainPageSimpleDTO getMainPageMedalDetail(Long userId);

    /**
     * 获取用户勋章数量（勋章数量等于：成就勋章的数量（同一个等级算一个）+ 定制勋章的数量）
     *
     * @param userId 用户id
     * @return 勋章总数
     */
    int getUserMedalNum(Long userId);
}