package com.bxm.egg.user.medal.msg.sender;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.medal.msg.UserMedalProcessor;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/5 6:32 下午
 */
@Slf4j
@Component
@EnableBinding(UserMedalProcessor.class)
@AllArgsConstructor
public class UserMedalCounterSenderService {
    @Qualifier(value = "userMedalOutPut")
    private MessageChannel userMedalOutPut;

    /**
     * 向消息队列中发送用户勋章统计数据改变相关数据
     *
     * @param userMedalCounterDTO 消息对象
     */
    public void send(UserMedalCounterDTO userMedalCounterDTO) {
        log.info("发送用户改变勋章统计数据消息：{}", JSON.toJSONString(userMedalCounterDTO));
        userMedalOutPut.send(MessageBuilder.withPayload(userMedalCounterDTO).build());
    }
}