package com.bxm.egg.user.medal.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.enums.UserMedalCounterTypeEnum;
import com.bxm.egg.user.enums.UserMedalTypeEnum;
import com.bxm.egg.user.medal.strategy.AbstractMedalCounterStrategy;
import com.bxm.egg.user.model.dto.medal.MedalExtDataDTO;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 鸡蛋数量统计策略类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/23 9:38 上午
 */
@Slf4j
@Component
@AllArgsConstructor
public class EggCounterStrategy extends AbstractMedalCounterStrategy {

    private UserAccountService userAccountService;

    /**
     * 鸡蛋相关的勋章，并且数量从低到高
     */
    private static final UserMedalTypeEnum[] EGG_MEDAL_SORT_ARRAY = {
            UserMedalTypeEnum.EGG_NEW_USER,
            UserMedalTypeEnum.EGG_TALENT,
            UserMedalTypeEnum.EGG_FARMER,
            UserMedalTypeEnum.RICH_ONE_PLACE,
            UserMedalTypeEnum.RICH_EQUAL_STATE
    };

    @Override
    protected void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {
        //1、查询账户获得鸡蛋总数数量
        UserAccountEntity userAccountInfo = userAccountService.getUserAccountInfo(userMedalCounterDTO.getUserId());

        Integer allEggNum = userAccountInfo.getAllEgg();

        if (allEggNum == 0) {
            return;
        }

        //2、获取鸡蛋数量勋章的所有信息，判断是否达到条件
        for (UserMedalTypeEnum userMedalTypeEnum : EGG_MEDAL_SORT_ARRAY) {
            // 返回true，表示当前等级是匹配的，则继续查找，判断下一个等级是否匹配,直到不匹配为止
            boolean match = handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, userMedalTypeEnum);
            if (!match) {
                break;
            }
        }
    }

    @Override
    protected String counterType() {
        return UserMedalCounterTypeEnum.EGG_NUM.name();
    }

    private boolean handleEggMedal(Long userId, Integer allEggNum, UserMedalTypeEnum userMedalTypeEnum) {
        List<UserMedalInfoEntity> medalInfoEntityList = achievementMedalCacheManager.getMedalListByType(userMedalTypeEnum.name());

        for (UserMedalInfoEntity userMedalInfoEntity : medalInfoEntityList) {
            MedalExtDataDTO medalExtDataDTO = JSON.parseObject(userMedalInfoEntity.getRuleExtData(), MedalExtDataDTO.class);
            if (allEggNum >= medalExtDataDTO.getTargetValue()) {
                // 尝试给达到条件的用户发放勋章
                grantAchievementMedal(userId, userMedalInfoEntity);
                return true;
            }
        }

        return false;
    }
}