package com.bxm.egg.user.reward.impl;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.user.constant.UserBizConfigProperties;
import com.bxm.egg.user.enums.TempInviteSourceTypeEnum;
import com.bxm.egg.user.info.UserBaseInfoService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.integration.SixEnjoyUserIntegrationService;
import com.bxm.egg.user.integration.farm.ChickenGroupIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyFriendsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserWxIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.UserWechatDelBindLogMapper;
import com.bxm.egg.user.model.bo.UserInviteBO;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.bxm.egg.user.model.entity.UserWechatDelBindLogEntity;
import com.bxm.egg.user.model.param.UserBindWxParam;
import com.bxm.egg.user.properties.SixEnjoyUrlProperties;
import com.bxm.egg.user.reward.UserRewardService;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.sync.facade.dto.UserRewardDTO;
import com.bxm.sync.facade.param.HuolaUserWxParam;
import com.bxm.sync.facade.param.UpdateUserRewardParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2021/12/22 10:28
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserRewardServiceImpl implements UserRewardService {

    private final SixEnjoyUserIntegrationService enjoyUserIntegrationService;

    private final UserEggInviteService userEggInviteService;

    private final SixEnjoyUserAccountIntegrationService enjoyUserAccountIntegrationService;

    private final UserBizConfigProperties userBizConfigProperties;

    private final UserBaseInfoService userBaseInfoService;

    private final ChickenGroupIntegrationService chickenGroupIntegrationService;

    private final SixEnjoyFriendsIntegrationService sixEnjoyFriendsIntegrationService;

    private final SixEnjoyUrlProperties sixEnjoyUrlProperties;

    private final MessageFacadeIntegrationService messageFacadeIntegrationService;

    private final SixEnjoyUserWxIntegrationService sixEnjoyUserWxIntegrationService;

    private final UserWechatDelBindLogMapper wechatDelBindLogMapper;


    @Override
    @Async
    public void sendUserBindWxReward(UserBindWxParam userBindWxParam, UserRewardDTO userRewardInfo) {
        //发送用户奖励
        UserInviteBO userInviteBO = sendUserReward(userRewardInfo, userBindWxParam);
        //给邀请人发送奖励
        newSendInviteUserReward(userRewardInfo, userBindWxParam, userInviteBO);
        //同步微信数据到六享
        syncWxInfoToSixEnjoy(userBindWxParam);
    }

    private void syncWxInfoToSixEnjoy(UserBindWxParam userBindWxParam) {
        HuolaUserWxParam huolaUserWxParam = new HuolaUserWxParam();
        huolaUserWxParam.setCreateTime(new Date());
        huolaUserWxParam.setHeadImg(userBindWxParam.getHeadImageUrl());
        huolaUserWxParam.setNickname(userBindWxParam.getNickName());
        huolaUserWxParam.setOpenId(userBindWxParam.getOpenId());
        huolaUserWxParam.setUnionId(userBindWxParam.getUnionId());
        huolaUserWxParam.setUserId(userBindWxParam.getUserId());
        sixEnjoyUserWxIntegrationService.syncWxInfoToSixEnjoy(huolaUserWxParam);
    }


    private UserInviteBO sendUserReward(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam) {
        UserInviteBO userInviteBO = UserInviteBO.builder().build();
        userInviteBO.setUserId(userRewardInfo.getUserId());
        //填充邀请关系
        userInviteBO.setInviteUserInfo(fillInviteUserInfo(userRewardInfo, userBindWxParam));

        log.info("用户当前奖励信息：userRewardInfo：{}，邀请人信息：{}", JSON.toJSONString(userRewardInfo), JSON.toJSONString(userInviteBO));

        UserBriefInfoDTO inviteUserInfo = userInviteBO.getInviteUserInfo();
        String inviteName = null;
        if (Objects.nonNull(inviteUserInfo)) {
            inviteName = inviteUserInfo.getNickname();
        }
        UpdateUserRewardParam updateUserRewardParam = new UpdateUserRewardParam();

        //如果发过微信奖励，并且没法注册奖励，只补偿300g,不更新邀请人
        if (!userRewardInfo.getRegisterReward() && userRewardInfo.getWxReward()) {
            //如果用户存在邀请人，且不是临时关系的类型，则要给邀请人奖励，否则不给
            if (Objects.equals(userRewardInfo.getIsTempInvite(), Boolean.FALSE)) {
                userInviteBO.setSendInviteUserReward(userBizConfigProperties.getInviteReward() * 2);
            }
            //如果是临时邀请
            if (Objects.equals(userRewardInfo.getIsTempInvite(), Boolean.TRUE) || Objects.isNull(userRewardInfo.getIsTempInvite())) {
                //为了快速上线，这个id之后的新用户，都发400g，并绑定邀请关系,否则则不绑定关系
                if (userRewardInfo.getUserId() < 652452L) {
                    userInviteBO.setInviteUserInfo(null);
                } else {
                    userInviteBO.setSendInviteUserReward(userBizConfigProperties.getInviteReward() * 2);
                }
            }


            //发送奖励
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("新用户注册奖励");
            if (inviteName != null) {
                stringBuilder.append("（邀请人:").append(inviteName).append("）");
            }
            enjoyUserAccountIntegrationService.addFoodsNum(userBindWxParam.getUserId(),
                    userBizConfigProperties.getRegisterReward(), stringBuilder.toString());

            updateUserRewardParam.setRegisterReward(true);
            updateUserRewardParam.setDevcId(userBindWxParam.getDevcId());

            //更新信息
            updateUserRewardParam.setUserId(userBindWxParam.getUserId());
            updateUserRewardParam.setNickname(userBindWxParam.getNickName());
            updateUserRewardParam.setHeadImg(userBindWxParam.getHeadImageUrl());
            enjoyUserIntegrationService.updateUserReward(updateUserRewardParam);
            return userInviteBO;
        }

        boolean registerReward = sendRegisterReward(userInviteBO, userRewardInfo.getRegisterReward(), userRewardInfo.getRegisterRewardPhone());

        boolean wxReward = sendWxReward(userInviteBO, userRewardInfo.getWxReward(), userBindWxParam.getUnionId());

        updateUserRewardParam.setRegisterReward(registerReward);
        updateUserRewardParam.setDevcId(userBindWxParam.getDevcId());
        updateUserRewardParam.setWxReward(wxReward);

        //更新信息
        updateUserRewardParam.setUserId(userBindWxParam.getUserId());
        updateUserRewardParam.setNickname(userBindWxParam.getNickName());
        updateUserRewardParam.setHeadImg(userBindWxParam.getHeadImageUrl());
        enjoyUserIntegrationService.updateUserReward(updateUserRewardParam);
        return userInviteBO;
    }

    private Boolean sendWxReward(UserInviteBO userInviteBO, Boolean wxReward, String unionId) {
        UserBriefInfoDTO inviteUserInfo = userInviteBO.getInviteUserInfo();
        String inviteName = null;
        if (Objects.nonNull(inviteUserInfo)) {
            inviteName = inviteUserInfo.getNickname();
        }
        if (!wxReward) {
            UserWechatDelBindLogEntity lastDelBindLog = wechatDelBindLogMapper.getLastDelBindLog(userInviteBO.getUserId(), unionId);
            //如果用户解绑过微信，或者微信被解绑过，则不发600g
            if (Objects.nonNull(lastDelBindLog)) {
                //发送奖励
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("此微信或用户已发放过微信绑定奖励");
                stringBuilder.append("，用户id为：【").append(lastDelBindLog.getUserId()).append("】");
                enjoyUserAccountIntegrationService.addFoodsNum(userInviteBO.getUserId(),
                        1, stringBuilder.toString());
                return true;
            }

            //发送奖励
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("新用户微信绑定奖励");
            if (inviteName != null) {
                stringBuilder.append("（邀请人:").append(inviteName).append("）");
            }
            enjoyUserAccountIntegrationService.addFoodsNum(userInviteBO.getUserId(),
                    userBizConfigProperties.getWxBindReward(), stringBuilder.toString());
            userInviteBO.setSendInviteUserReward(userInviteBO.getSendInviteUserReward() == null ?
                    userBizConfigProperties.getInviteReward() :
                    userInviteBO.getSendInviteUserReward() + userBizConfigProperties.getInviteReward());
            return true;
        }
        return false;
    }

    private Boolean sendRegisterReward(UserInviteBO userInviteBO, Boolean registerReward, String phone) {

        UserBriefInfoDTO inviteUserInfo = userInviteBO.getInviteUserInfo();
        String inviteName = null;
        if (Objects.nonNull(inviteUserInfo)) {
            inviteName = inviteUserInfo.getNickname();
        }

        if (!registerReward) {
            //发送奖励
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("新用户注册奖励");
            if (inviteName != null) {
                stringBuilder.append("（邀请人:").append(inviteName).append("）");
            }
            enjoyUserAccountIntegrationService.addFoodsNum(userInviteBO.getUserId(),
                    userBizConfigProperties.getRegisterReward(), stringBuilder.toString());
            userInviteBO.setSendInviteUserReward(userInviteBO.getSendInviteUserReward() == null ?
                    userBizConfigProperties.getInviteReward() :
                    userInviteBO.getSendInviteUserReward() + userBizConfigProperties.getInviteReward());
            return true;
        } else {
            //发送奖励
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("此设备已发放过设备奖励");
            if (StringUtils.isNotBlank(phone)) {
                stringBuilder.append("，手机号为：【").append(phone).append("】");
            }
            enjoyUserAccountIntegrationService.addFoodsNum(userInviteBO.getUserId(),
                    1, stringBuilder.toString());
        }
        return false;
    }

    private UserBriefInfoDTO fillInviteUserInfo(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam) {

        //如果用户存在邀请人，且不是临时关系的类型，则不用走火啦临时邀请关系
        if (Objects.equals(userRewardInfo.getIsTempInvite(), Boolean.FALSE)) {
            return userBaseInfoService.getSingleUserBriefInfo(userRewardInfo.getInviteUserId());
        }
        TempInviteBindEntity userTempBindInvite = userEggInviteService.getUserTempBindInvite(userBindWxParam.getUnionId());
        //如果临时关系都存在的话，看时间
        if (Objects.equals(userRewardInfo.getIsTempInvite(), Boolean.TRUE) && Objects.nonNull(userTempBindInvite)) {
            //谁最晚，则用谁的
            if (userTempBindInvite.getCreateTime().getTime() >= userRewardInfo.getTempInviteDate().getTime()) {
                //插入合养信息
                inviteJoinGroup(userTempBindInvite, userBindWxParam.getUserId());
                return userBaseInfoService.getSingleUserBriefInfo(userTempBindInvite.getUserId());
            } else {
                return userBaseInfoService.getSingleUserBriefInfo(userRewardInfo.getInviteUserId());
            }
        }

        //如果六享存在临时则用六享
        if (Objects.equals(userRewardInfo.getIsTempInvite(), Boolean.TRUE)) {
            return userBaseInfoService.getSingleUserBriefInfo(userRewardInfo.getInviteUserId());
        }

        //如果火啦存在临时则用火啦
        if (Objects.nonNull(userTempBindInvite)) {
            return userBaseInfoService.getSingleUserBriefInfo(userTempBindInvite.getUserId());
        }

        return null;
    }

    private void inviteJoinGroup(TempInviteBindEntity userTempBindInvite, Long userId) {
        //如果来源为合养页，则添加合养信息
        if (Objects.equals(TempInviteSourceTypeEnum.CHICKEN_GROUP_PAGE.getType(), userTempBindInvite.getSource())) {
            chickenGroupIntegrationService.inviteJoinGroup(userId, userTempBindInvite.getUserId());
        }
    }

    private void newSendInviteUserReward(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam, UserInviteBO userInviteBO) {
        //用户邀请信息不存在
        if (userInviteBO.getInviteUserInfo() == null) {
            return;
        }

        inviteRewardUpdate(userRewardInfo, userBindWxParam, userInviteBO);
    }

    private void inviteRewardUpdate(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam, UserInviteBO userInviteBO) {
        UserBriefInfoDTO inviteUserInfo = userInviteBO.getInviteUserInfo();

        //建立好友关系
        sixEnjoyFriendsIntegrationService.insertFriendsToSixEnjoy(userBindWxParam.getUserId(), inviteUserInfo.getUserId());
        //更新邀请人关系，更新了六享数据则会触发canal同步邀请关系，火啦不用增加邀请关系
        Boolean updateUserInvite = enjoyUserIntegrationService.updateUserInvite(userBindWxParam.getUserId(), inviteUserInfo.getUserId());
        //如果更新没成功，且邀请信息本来就存在数据库中，则说明是老板APP用户邀请的，用了新版绑定微信
        if (!updateUserInvite && Objects.equals(null, userRewardInfo.getIsTempInvite())) {
            log.error("给六享绑定邀请关系失败，请检查dubbo问题还是用户已有绑定人：userId:{},inviteUserInfo:{}", userBindWxParam.getUserId(), JSON.toJSONString(inviteUserInfo));
            return;
        }

        //老版APP用户邀请的，用了新版绑定微信，补偿邀请信息
        if (Objects.equals(Boolean.FALSE, userRewardInfo.getIsTempInvite())) {
            EggInviteEntity eggInviteEntity = new EggInviteEntity();
            eggInviteEntity.setId(SequenceHolder.nextLongId());
            eggInviteEntity.setUserId(inviteUserInfo.getUserId());
            eggInviteEntity.setBeInviteUserId(userBindWxParam.getUserId());
            eggInviteEntity.setCreateTime(new Date());
            eggInviteEntity.setBeInviteRegTime(new Date());
            userEggInviteService.insertInviteInfo(eggInviteEntity);
        }
        //更新邀请人关系成功，则发送邀请奖励
        sendInviteUserReward(inviteUserInfo.getUserId(), userBindWxParam.getNickName(), userInviteBO.getSendInviteUserReward());
    }

    private void sendInviteUserReward(Long inviteUserId, String beInviteUserName, int sendInviteUserReward) {
        if (sendInviteUserReward > 0) {
            //发送奖励
            enjoyUserAccountIntegrationService.addFoodsNum(inviteUserId,
                    sendInviteUserReward, String.format(userBizConfigProperties.getInviteSixEnjoyFoodsLog(), beInviteUserName));

            PushMessage message = PushMessage.build("邀请好友奖励已送达",
                    String.format(userBizConfigProperties.getInvitePushContent(), beInviteUserName, sendInviteUserReward));
            message.assign(inviteUserId);
            message.getPayloadInfo().setProtocol(ProtocolFactory.appH5()
                    .url(sixEnjoyUrlProperties.getInvitePage())
                    .build());

            messageFacadeIntegrationService.sendPushMessage(message);
        }
    }
}
