package com.bxm.egg.user.role.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.constant.UserEggRoleEnum;
import com.bxm.egg.user.mapper.UserEggRoleMapper;
import com.bxm.egg.user.model.entity.UserEggRoleEntity;
import com.bxm.egg.user.role.UserEggRoleService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/23 7:26 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserEggRoleServiceImpl implements UserEggRoleService {

    private final UserEggRoleMapper userEggRoleMapper;

    @Override
    public List<Integer> getUserRoleType(Long userId) {
        LambdaQueryWrapper<UserEggRoleEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserEggRoleEntity::getUserId, userId);

        List<UserEggRoleEntity> roleEntityList = userEggRoleMapper.selectList(queryWrapper);

        List<Integer> roleList = roleEntityList.stream().map(UserEggRoleEntity::getRoleId).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(roleList)) {

            roleList = new ArrayList<>();

            roleList.add(UserEggRoleEnum.GENERATE.getCode());
            return roleList;
        }

        return roleList;
    }
}