package com.bxm.egg.user.support;

import com.bxm.egg.user.model.dto.CustomerHomePageDTO;
import com.bxm.egg.user.model.dto.OneselfHomePageDTO;

/**
 * 主页service接口
 *
 * @author wzy
 * @date 2021年09月17日09:34:56
 */
public interface HomePageService {

    /**
     * 主态个人主页
     *
     * @param userId 用户id
     * @return 个人主页信息
     */
    OneselfHomePageDTO getOneselfHomePage(Long userId);

    /**
     * 客态个人主页
     *
     * @param userId       当前用户
     * @param targetUserId 目标用户
     * @return 他人主页信息
     */
    CustomerHomePageDTO getCustomerHomePage(Long targetUserId, Long userId);



}
