package com.bxm.egg.user.support.impl;

import com.bxm.egg.user.support.NativeUserService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

@Slf4j
@Service
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class NativeUserServiceImpl implements NativeUserService {

    /**
     * 年龄段组装
     */
    @Override
    public String getGeneration(Date userBirthday) {
        String generationStr = "";
        if (null != userBirthday) {
            LocalDate birthday = userBirthday.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            String gen = getGeneration(birthday);
            if (!StringUtils.isEmpty(gen)) {
                generationStr = gen;
            }
        }
        return generationStr;
    }

    public String getGeneration(LocalDate birthday) {
        String generationStr = null;
        if (null != birthday) {
            int year = birthday.getYear();
            int decade = year / 10;
            String s = String.valueOf(decade);
            generationStr = s.substring(s.length() - 1) + "0后";
        }
        return generationStr;
    }

    /**
     * 不超过5公里，就是1公里以内，2公里以内，3公里以内，4公里以内，5公里以内； 超过5公司就显示10公里以内，20公里以内，30公里以内，依次类推。
     */
    private Integer getDistance(Integer originalDistance) {
        if (originalDistance == 0) {
            return 0;
        } else if (originalDistance <= 1) {
            return 1;
        } else if (originalDistance <= 2) {
            return 2;
        } else if (originalDistance <= 3) {
            return 3;
        } else if (originalDistance <= 4) {
            return 4;
        } else if (originalDistance <= 5) {
            return 5;
        } else if (originalDistance <= 10) {
            return 10;
        } else if (originalDistance <= 20) {
            return 20;
        } else if (originalDistance <= 30) {
            return 30;
        } else if (originalDistance <= 40) {
            return 40;
        } else if (originalDistance <= 50) {
            return 50;
        }
        return originalDistance;
    }
}
