package com.bxm.egg.user.support.impl;

import com.bxm.egg.user.mapper.UserInformMapper;
import com.bxm.egg.user.model.param.UserInformParam;
import com.bxm.egg.user.model.vo.UserInform;
import com.bxm.egg.user.support.UserInformService;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 用户举报service
 *
 * @author wzy
 * @date 2021年10月11日18:59:21
 */
@Service
@AllArgsConstructor(onConstructor = @__(@Autowired))
public class UserInformServiceImpl implements UserInformService {

    private final UserInformMapper userInformMapper;

    @Override
    public Boolean userInformService(UserInformParam userInformParam) {
        UserInform userInform = new UserInform();
        BeanUtils.copyProperties(userInformParam, userInform);
        userInform.setAddTime(new Date());
        userInform.setResult(0);
        userInformMapper.insertSelective(userInform);
        return Boolean.TRUE;
    }
}
