package com.bxm.egg.user.timer;

import com.bxm.egg.user.mapper.warmlevel.UserWarmValueFlowMapper;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @author lowi
 * @date 2022/3/22 10:29
 */
@Component
public class CleanWarmFlowTask extends AbstractCronXxlJob {

    @Resource
    UserWarmValueFlowMapper userWarmValueFlowMapper;

    @Override
    protected void executeLogic() {
        Date date = DateUtils.addDays(new Date(), -15);
        int flowByDate = userWarmValueFlowMapper.delWarmFlowByDate(date);
        while (flowByDate > 0) {
            flowByDate = userWarmValueFlowMapper.delWarmFlowByDate(date);
        }
    }

    @Override
    protected String cron() {
        return "0 0 2 * * ?";
    }

    @Override
    public String jobDesc() {
        return "定时清除温暖值流水信息";
    }

    @Override
    public String author() {
        return "耿杨杨";
    }
}
