package com.bxm.egg.user.timer;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.integration.sync.SixEnjoyDataStatisticsIntegrationService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.dto.invite.RollBarrageDTO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.sync.facade.dto.UserUseEggNumDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lowi
 * @date 2021/12/1 14:20
 */
@Component
@Slf4j
@AllArgsConstructor
public class RollBarrageLoadTask extends AbstractCronXxlJob {

    private final SixEnjoyDataStatisticsIntegrationService statisticsIntegrationService;

    private final UserInfoCacheService userInfoCacheService;

    private final RedisStringAdapter redisStringAdapter;

    @Override
    protected void executeLogic() {
        redisStringAdapter.remove(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy());


        List<UserUseEggNumDTO> userUseEggNumMaxList = statisticsIntegrationService.getUserUseEggNumMaxList();
        List<RollBarrageDTO> rollBarrageDTOList = userUseEggNumMaxList.stream().map(userUseEggNumDTO -> {
            UserBriefInfoDTO userBriefInfoDTO = userInfoCacheService.loadBriefInfo(userUseEggNumDTO.getUserId());
            String nickname = userBriefInfoDTO.getNickname();
            return RollBarrageDTO.builder()
                    .eggNums(userUseEggNumDTO.getUseEggNum())
                    .nickname(StringUtils.hideRealName(nickname))
                    .build();
        }).collect(Collectors.toList());

        redisStringAdapter.set(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), rollBarrageDTOList);
    }

    @Override
    protected String cron() {
        return "0 0 2 * * ?";
    }

    @Override
    public String jobDesc() {
        return "每天2点1加载滚动弹幕";
    }

    @Override
    public String author() {
        return "耿杨杨";
    }
}
