package com.bxm.egg.user.utils;

import com.bxm.egg.user.vo.IP;
import com.bxm.newidea.component.tools.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;

import static com.bxm.newidea.component.tools.FileUtils.getClassRootPath;

/**
 * 临时：IP工具类，用于判断IP是否国内IP，用于IOS提包时进行处理
 *
 * @author zhaoyadong 2018/11/30 16:43
 * @desc
 */
public class IPConvertUtil {

    // 默认编码类型
    private final static String DEFAULT_CHARSET = "UTF-8";

    // 默认超时时间
    private final static int DEFAULT_TIME_OUT = 20000;

    private static final Logger logger = LoggerFactory.getLogger(IPConvertUtil.class);

    private static int offset;

    private static int[] index = new int[65536];

    private static boolean initd = true;

    private static ByteBuffer dataBuffer;

    private static ByteBuffer indexBuffer;

    private static ReentrantLock lock = new ReentrantLock();

    private static void init() {
        if (!initd) {
            return;
        }
        if (dataBuffer == null) {
            logger.debug("init load ip file");
            try {
                IPConvertUtil.load();
            } catch (Exception e) {
                logger.error("IP工具初始化失败", e);
            }
            logger.debug("load success ip file");
        }
        initd = false;
    }

    public static IP find(String ip) {
        init();

        try {
            String[] array = findIp(ip);
            if (ArrayUtils.isEmpty(array)) {
                return null;
            }

            if (array.length > 11) {
                return new IP(array[0],
                        array[1],
                        array[2],
                        array[3],
                        array[4],
                        array[5],
                        array[6],
                        array[7],
                        array[8],
                        array[9],
                        NumberUtils.toInt(array[10], -1),
                        array[11]);
            }

            if (array.length > 2) {
                return new IP(array[0],
                        array[1],
                        array[2]);
            }
        } catch (Exception e) {
            logger.error("ip工具调用失败，请检查初始化");
        }

        return null;
    }

    private static String[] findIp(String ip) {
        String[] ips = ip.split("\\.");
        int prefix_value = (Integer.valueOf(ips[0]) * 256 + Integer.valueOf(ips[1]));
        long ip2long_value = ip2long(ip);
        int start = index[prefix_value];
        int max_comp_len = offset - 262144 - 4;
        long tmpInt;
        long index_offset = -1;
        int index_length = -1;
        byte b = 0;
        for (start = start * 9 + 262144; start < max_comp_len; start += 9) {
            tmpInt = int2long(indexBuffer.getInt(start));
            if (tmpInt >= ip2long_value) {
                index_offset = bytesToLong(b, indexBuffer.get(start + 6), indexBuffer.get(start + 5), indexBuffer.get(start + 4));
                index_length = ((0xFF & indexBuffer.get(start + 7)) << 8) + (0xFF & indexBuffer.get(start + 8));
                break;
            }
        }

        byte[] areaBytes;

        lock.lock();
        try {
            dataBuffer.position(offset + (int) index_offset - 262144);
            areaBytes = new byte[index_length];
            dataBuffer.get(areaBytes, 0, index_length);
        } finally {
            lock.unlock();
        }

        return new String(areaBytes, Charset.forName("UTF-8")).split("\t", -1);
    }

    private byte[] getBytesByFile() {
        String urlStr = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.datx";
        InputStream is = null;
        ByteArrayOutputStream os = null;
        byte[] buff = new byte[1024];
        int len = 0;
        try {
            URL url = new URL(UriUtils.encodePath(urlStr, DEFAULT_CHARSET));
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestProperty("Content-Type", "plain/text;charset=" + DEFAULT_CHARSET);
            conn.setRequestProperty("charset", DEFAULT_CHARSET);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setReadTimeout(DEFAULT_TIME_OUT);
            conn.connect();
            is = conn.getInputStream();
            os = new ByteArrayOutputStream();
            while ((len = is.read(buff)) != -1) {
                os.write(buff, 0, len);
            }
            return os.toByteArray();
        } catch (IOException e) {
            logger.error("发起请求出现异常:", e);
            return null;
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    logger.error("【关闭流异常】");
                }
            }
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    logger.error("【关闭流异常】");
                }
            }
        }
    }

    private static byte[] getBytesByFile(File ipFile) throws IOException {
        InputStream fin = null;

        long len = ipFile.length();

        byte[] bs = new byte[new Long(len).intValue()];
        try {
            fin = new FileInputStream(ipFile);
            int readBytesLength = 0;
            int i;
            while ((i = fin.available()) > 0) {
                fin.read(bs, readBytesLength, i);
                readBytesLength += i;
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return bs;
    }

    private static long bytesToLong(byte a, byte b, byte c, byte d) {
        return int2long((((a & 0xff) << 24) | ((b & 0xff) << 16) | ((c & 0xff) << 8) | (d & 0xff)));
    }

    private static int str2Ip(String ip) {
        String[] ss = ip.split("\\.");
        int a, b, c, d;
        a = Integer.parseInt(ss[0]);
        b = Integer.parseInt(ss[1]);
        c = Integer.parseInt(ss[2]);
        d = Integer.parseInt(ss[3]);
        return (a << 24) | (b << 16) | (c << 8) | d;
    }

    private static long ip2long(String ip) {
        return int2long(str2Ip(ip));
    }

    private static long int2long(int i) {
        long l = i & 0x7fffffffL;
        if (i < 0) {
            l |= 0x080000000L;
        }
        return l;
    }

    /**
     * 初始化值
     */
    private static void load() {
        lock.lock();
        try {
            File file = getIpFile();
            byte[] bytes = getBytesByFile(file);
            dataBuffer = ByteBuffer.wrap(bytes);
            dataBuffer.position(0);
            offset = dataBuffer.getInt();
            byte[] indexBytes = new byte[offset];
            dataBuffer.get(indexBytes, 0, offset - 4);
            indexBuffer = ByteBuffer.wrap(indexBytes);
            indexBuffer.order(ByteOrder.LITTLE_ENDIAN);

            for (int i = 0; i < 256; i++) {
                for (int j = 0; j < 256; j++) {
                    index[i * 256 + j] = indexBuffer.getInt();
                }
            }
            indexBuffer.order(ByteOrder.BIG_ENDIAN);
        } catch (Exception e) {
            throw new RuntimeException("load", e);
        } finally {
            lock.unlock();
        }
    }

    /**
     * 获取远端文件
     *
     * @return
     */
    private static File getIpFile() {
        String lastVersion = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.datx";
        String fileName = StringUtils.substringAfterLast(lastVersion, "/");

        String rootPath = getClassRootPath();
        File appFile = new File(rootPath + fileName);

        if (appFile.exists()) {
            return appFile;
        }

        try {
            FileUtils.copyURLToFile(new URL(lastVersion), appFile);
        } catch (IOException e) {
            logger.error("ip存放的配置文件路径不正确", e);
        }

        return appFile;
    }
}