package com.bxm.egg.user.warmlevel;

import com.bxm.egg.user.facade.dto.UserWarmValueUpDTO;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.warmlevel.*;
import com.bxm.egg.user.model.param.warmlevel.UserWarmValueDetailParam;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;

import java.util.List;

/**
 * @author lowi
 * @date 2021/3/2 10:16
 */

public interface UserWarmLevelService {
    /**
     * 获取用户等级权益信息
     *
     * @param warmValue 温暖值
     * @return 用户权益等级信息
     */
    UserEquityDTO getLevelEquityInfo(Integer warmValue);

    /**
     * 获取温暖值规则增加详情
     *
     * @return 规则增加详情
     */
    List<UserWarmValueRuleDetailDTO> getWarmValueAddInfo();

    /**
     * 获取温暖值规则扣除详情
     *
     * @return 规则增加详情
     */
    List<UserWarmValueRuleDetailDTO> getWarmValueDeductionInfo();

    /**
     * 获取用户温暖值信息
     *
     * @param userId 用户id
     * @return 用户温暖值信息
     */
    UserWarmLevelInfoDTO getUserWarmValueInfo(Long userId);

    /**
     * 获取用户的等级列表
     *
     * @param userId 用户等级
     * @return 用户等级列表
     */
    List<UserLevelListDTO> getUserLevelList(Long userId);

    /**
     * 获取等级开放的功能
     *
     * @return 等级开放的功能
     */
    List<LevelEquityDTO> getLevelEquityList();

    /**
     * 获取用户温暖值缓存信息
     *
     * @param userId 用户id
     * @return 用户温暖值缓存信息
     */
    UserWarmLevelInfoDTO getUserWarmInfoCache(Long userId);

    /**
     * 内部使用接口用户温暖值增加或减少
     *
     * @param userId       用户id
     * @param warmValue    温暖值
     * @param warmRuleEnum 规则类型
     * @return 返回结果
     */
    Boolean mockWarmAddOrDec(Long userId, Integer warmValue, WarmRuleEnum warmRuleEnum);

    /**
     * 获取温暖值规则
     *
     * @param type 规则类型{@link WarmRuleEnum}
     * @return 温暖值规则
     */
    WarmRuleDetail getWarmRule(String type);

    /**
     * 清理用户温暖值缓存触发升级之类的后续操作
     *
     * @param context 上下文
     */
    void delWarmCacheWarmLevelUp(WarmActionContext context);

    /**
     * 获取用户的温暖值明细列表
     *
     * @param userWarmValueDetailParam 请求参数
     * @return 返回列表信息
     */
    List<UserWarmValueDetailDTO> getWarmDetailListByUser(UserWarmValueDetailParam userWarmValueDetailParam);


    /**
     * 获取用户等级的弹窗数据
     *
     * @param userId 用户id
     * @return 等级弹窗数据
     */
    UserWarmValueUpDTO getUserLevelPopData(Long userId);

    /**
     * 权益不可用信息返回
     *
     * @param userId 用户id
     * @param type   权益类型
     * @return 权益不可用信息返回
     */
    EquityNotAbleInfo getNotAvailablePopupExplain(Long userId, String type);

    /**
     * 更新用户的温暖值
     *
     * @param userId    用户id
     * @param warmValue 温暖值
     */
    void updateUserWarmInfo(Long userId, Integer warmValue);
}
