package com.bxm.egg.user.warmlevel.impl.context;

import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.facade.param.UserWarmActionParam;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.impl.callback.WarmActionCallback;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @author lowi
 */
public class WarmActionContext {

    public WarmActionContext(UserWarmActionParam param) {
        this.originParam = param;
    }

    /**
     * 回调接口，调用方提供，用于生命周期中自定义业务逻辑
     */
    private WarmActionCallback callback;

    /**
     * 原始的请求参数，不可变更
     */
    private final UserWarmActionParam originParam;

    private WarmRuleDetail warmRuleDetail;

    public WarmRuleDetail getWarmRuleDetail() {
        return warmRuleDetail;
    }

    public void setWarmRuleDetail(WarmRuleDetail warmRuleDetail) {
        this.warmRuleDetail = warmRuleDetail;
    }

    public WarmRuleEnum getAction() {
        return originParam.getWarmRuleEnum();
    }

    public Long getUserId() {
        return originParam.getUserId();
    }

    public WarmActionCallback getCallback() {
        return callback;
    }

    public void setCallback(WarmActionCallback callback) {
        this.callback = callback;
    }

    public UserWarmActionParam getOriginParam() {
        return originParam;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
