package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.ContinuitySignRule;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 用户连续签到温暖值发放
 *
 * @author lowi
 * @date 2021/03/03 10:46
 */
@Component
public class UserContinuitySignActionHandler extends AbstractWarmActionHandler {

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected void execAction(WarmActionContext context) {
        //获取此规则需要更改的温暖值
        //连续签到特殊处理
        //连续签到拦截已处理好需要增加的温暖值，无需再计算
        WarmRuleDetail warmRule = getWarmRule(context.getAction().name());
        warmRule.setWarmValue(context.getOriginParam().getWarmValue());
        context.setWarmRuleDetail(warmRule);
    }

    @Override
    protected void afterPost(WarmActionContext context) {
        KeyGenerator key = RedisConfig.USER_SIGN_WARM.copy().appendKey(DateUtils.formatDate(new Date()));
        redisSetAdapter.add(key, context.getUserId());
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.CONTINUITY_SIGN;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return ContinuitySignRule.class;
    }
}
