package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.DataFinishRule;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 用户完善资料温暖值发放
 *
 * @author lowi
 * @date 2021/03/03 10:46
 */
@Component
public class UserDataFinishActionHandler extends AbstractWarmActionHandler {

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected void execAction(WarmActionContext context) {
        //获取此规则需要更改的温暖值
        context.setWarmRuleDetail(getWarmRule(context.getAction().name()));
    }

    @Override
    protected void afterPost(WarmActionContext context) {
        redisSetAdapter.add(RedisConfig.USER_DATA_FINISH_WARM.copy(), context.getUserId());
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.FINISH_ONESELF_DATA;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return DataFinishRule.class;
    }
}
