package com.bxm.egg.user.warmlevel.impl.rule;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2021/3/3 16:28
 */
@Component
@AllArgsConstructor
public class LoginRule implements WarmRule {

    private final RedisSetAdapter redisSetAdapter;

    @Override
    public Message apply(WarmActionContext context) {
        KeyGenerator key = RedisConfig.USER_LOGIN_WARM.copy().appendKey(DateUtils.formatDate(new Date()));
        Boolean result = redisSetAdapter.exists(key, context.getUserId());
        if (Objects.nonNull(result) && result) {
            return Message.build(false).setMessage("已发放过登录温暖值奖励");
        }
        return Message.build(true);
    }

    @Override
    public boolean retryOnFailed() {
        return false;
    }
}
