package com.bxm.egg.user.warmlevel.impl.rule;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author lowi
 * @date 2021/3/3 16:28
 */
@Component
@AllArgsConstructor
public class WarmMerchantAuthRule implements WarmRule {

    private final RedisSetAdapter redisSetAdapter;

    @Override
    public Message apply(WarmActionContext context) {
        Boolean result = redisSetAdapter.exists(RedisConfig.USER_MERCHANT_AUTN_WARM.copy(), context.getUserId());
        if (Objects.nonNull(result) && result) {
            return Message.build(false).setMessage("已发放过完成商家认证温暖值奖励");
        }
        return Message.build(true);
    }

    @Override
    public boolean retryOnFailed() {
        return false;
    }
}
