package com.bxm.localnews.activity.controller;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.activity.config.ActivityDrawProperties;
import com.bxm.localnews.activity.param.CashDetailParam;
import com.bxm.localnews.activity.service.LotteryDrawService;
import com.bxm.localnews.activity.vo.WechatUserInfoVo;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.*;

@Api(tags = "2-11 小程序抽奖", description = "小程序抽奖相关操作")
@RestController
@RefreshScope
@RequestMapping("api/public/lotteryDraw")
public class LotteryDrawController {

    @Autowired
    private LotteryDrawService lotteryDrawService;

    @Autowired
    private ActivityDrawProperties activityDrawProperties;

    @ApiOperation(value = "2-11-1 获取抽奖用户信息", notes = "判断是否活动区域，返回用户钱包余额，剩余抽奖次数以及能否增加抽奖次数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "city", value = "市级信息", required = false),
            @ApiImplicitParam(name = "district", value = "区级信息", required = false)
    })
    @GetMapping("getUserInfo")
    public Json<WechatUserInfoVo> getUserInfo(@RequestParam(name = "userId") Long userId,
                                              @RequestParam(name = "city", required = false) String city,
                                              @RequestParam(name = "district", required = false) String district) {
        return ResultUtil.genSuccessResult(lotteryDrawService.getUserInfo(userId, city, district));
    }

    @ApiOperation(value = "2-11-2 获取奖项")
    @GetMapping("getPrizeList")
    public Json<List<BigDecimal>> getPrizeList() {
        return ResultUtil.genSuccessResult(lotteryDrawService.getPrizeList());
    }

    @ApiOperation(value = "2-11-3 获取中奖用户列表")
    @GetMapping("getWinUserList")
    public Json<List<WechatUserInfoVo>> getWinUserList() {
        return ResultUtil.genSuccessResult(lotteryDrawService.getWinUserList());
    }

    @ApiOperation(value = "2-11-4 抽奖", notes = "返回中奖金额")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = false),
            @ApiImplicitParam(name = "platform", value = "平台类型: 3:h5 4:小程序", required = false)
    })
    @PostMapping("lotteryDraw")
    public Json<String> lotteryDraw(@RequestParam(name = "userId") Long userId, BasicParam basicParam,
                                    @RequestParam(name = "areaCode", required = false) String areaCode) {
        return ResultUtil.genSuccessResult(lotteryDrawService.lotteryDraw(userId, basicParam.getPlatform(), areaCode));
    }

    @ApiOperation(value = "2-11-5 分享", notes = "增加抽奖次数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @PostMapping("share")
    public Json<Boolean> share(@RequestParam(name = "userId") Long userId) {
        return ResultUtil.genSuccessResult(lotteryDrawService.share(userId));
    }

    @ApiOperation(value = "2-11-6 获取明细")
    @GetMapping("getDetailPage")
    public Json<PageWarper<WechatUserInfoVo>> getDetailPage(CashDetailParam param) {
        return ResultUtil.genSuccessResult(lotteryDrawService.getDetailPage(param));
    }

    @ApiOperation(value = "2-11-7 分享开关控制", notes = "分享时：0 表示小程序 1表示H5")
    @GetMapping("/switch")
    public Json<Byte> getShareSwitch() {
        return ResultUtil.genSuccessResult(activityDrawProperties.getSwitchType());
    }

    @ApiOperation(value = "2-11-8 是否活动区域", notes = "判断是否活动区域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "city", value = "市级信息", required = false),
            @ApiImplicitParam(name = "district", value = "区级信息", required = false)
    })
    @GetMapping("isActiveArea")
    public Json<Boolean> isActiveArea(@RequestParam(name = "city", required = false) String city,
                                      @RequestParam(name = "district", required = false) String district) {
        return ResultUtil.genSuccessResult(lotteryDrawService.isActiveArea(city, district));
    }
}
