package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.AwakenStateModel;
import com.bxm.localnews.activity.vo.InviteRelation;
import com.bxm.localnews.activity.vo.InviteRelationVO;
import com.bxm.localnews.activity.vo.PrenticeRankingModel;
import com.bxm.localnews.user.dto.AddressBookDTO;
import com.bxm.localnews.user.vo.User;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Mapper
public interface InviteRelationMapper {

    int insertSelective(InviteRelation record);

    int updateByPrimaryKeySelective(InviteRelation record);

    List<InviteRelation> getInviteRelationListByUserId(AddressBookDTO addressBookDTO);

    int getInviteRelationCountByUserId(@Param("inviteRelation") AddressBookDTO addressBookDTO);

    int updateAttribute(@Param("userId") Long userId, @Param("retGold") BigDecimal retGold);

    int updateUpUpCoin(@Param("retCoin") BigDecimal retCoin, @Param("userId") Long userId);

    //查询徒弟和师傅的对应关系
    InviteRelation findselectiveByUserId(@Param("userId") Long userId, @Param("upUserId") Long upUserId);

    InviteRelation getInviteRelationByUserId(Long userId);


    List<User> listUnActivePrentices(Long userId);

    void updateUserState(@Param("id") Long id, @Param("state") Byte state);

    Long checkAwakeState(@Param("userId") Long userId, @Param("prenticeId") Long prenticeId);

    void awakeUser(Long userId);

    /**
     * 被唤醒一天内登录时
     */
    void updateUserActive(Long id);

    List<PrenticeRankingModel> listTopRanking();

    /**
     * 统计用户有效徒弟数量
     */
    int countUserEffectivePrentice(Long userId);

    List<InviteRelationVO> getInviteRelationVO(@Param("upUserId") Long upUserId);

    int countUserPrentice(@Param("upUserId") Long upUserId, @Param("startTime") Date startTime);


    /**
     * 累计徒孙奖励
     */
    BigDecimal getTotalDisplineCoin(Long userId);

    BigDecimal getTotalAttributedGold(Long userId);

}