package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.SignRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface SignRecordMapper {

    int insert(@Param("record") SignRecord record, @Param("tableName") String tableName);

    int insertSelective(@Param("record") SignRecord record, @Param("tableName") String tableName);

    SignRecord selectByPrimaryKey(@Param("id") Long id, @Param("tableName") String tableName);

    int updateByPrimaryKeySelective(@Param("record") SignRecord record, @Param("tableName") String tableName);

    int updateByPrimaryKey(@Param("record") SignRecord record, @Param("tableName") String tableName);

    List<SignRecord> listUserSignRecord(@Param("userId") Long userId, @Param("tableName") String tableName);

    int countSignToday(@Param("userId") Long userId, @Param("tableName") String tableName);

    /**
     * 获取用户的最后一条签到记录
     * @param userId    用户ID
     * @param tableName 用户签到记录的存储表
     * @return 签到记录
     */
    SignRecord getLastSignRecord(@Param("userId") Long userId, @Param("tableName") String tableName);

}