package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.param.HelpInfoQueryParam;
import com.bxm.localnews.activity.vo.HelpBaseInfo;
import com.bxm.localnews.activity.vo.HelpRankInfo;
import com.bxm.localnews.activity.vo.HelpUserInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface HelpInfoMapper {

    /**
     * 根据userId获取个人助力信息
     *
     * @param userId
     * @return
     */
    HelpBaseInfo getPersonalInfoByUserId(Long userId);

    /**
     * 根据团队id获取团队创建者id
     *
     * @param helperId
     * @return
     */
    Long getTeamCreatorById(Long helperId);

    /**
     * 根据userId获取团队助力信息
     *
     * @return
     */
    HelpBaseInfo getTeamInfoByUserId(Long userId);

    /**
     * 获取轮播列表
     *
     * @param size
     * @param userId
     * @return
     */
    List<HelpBaseInfo> getRoundList(@Param("size") Integer size, @Param("userId") Long userId);

    /**
     * 获取轮播用户id列表
     *
     * @param size
     * @param teamId
     * @return
     */
    List<Long> getRoundUserIdList(@Param("size") Integer size, @Param("teamId") Long teamId);

    /**
     * 获取已助力次数
     *
     * @return
     */
    Integer getHelpedNum();

    /**
     * 获取最近已助力者头像
     *
     * @param size
     * @return
     */
    List<Long> getHelpedUserIds(@Param("userId") Long userId, @Param("size") Integer size);

    /**
     * 获取排行榜
     *
     * @param param
     * @return
     */
    List<HelpRankInfo> getRankingList(HelpInfoQueryParam param);

    /**
     * 根据助力者id和类型获取助力信息
     *
     * @param helperId
     * @param type
     * @return
     */
    HelpRankInfo getRankInfoByHelperIdAndType(@Param("helperId") Long helperId, @Param("type") Byte type);

    /**
     * 根据userId统计助力信息
     *
     * @param userId
     * @return
     */
    int countUserHelpInfo(Long userId);

    /**
     * 根据团队名统计
     *
     * @param name
     * @return
     */
    int countHelpTeamByName(@Param("name") String name);

    /**
     * 插入助力信息
     *
     * @param record
     * @return
     */
    int insertHelpInfo(HelpBaseInfo record);

    /**
     * 插入团队信息
     *
     * @param record
     * @return
     */
    int insertTeamInfo(HelpBaseInfo record);

    /**
     * 插入用户团队信息
     *
     * @param teamId
     * @param userId
     * @return
     */
    int insertTeamUserRelation(@Param("teamId") Long teamId, @Param("userId") Long userId);

    /**
     * 增加邀请数
     *
     * @param helperId
     * @param type
     * @return
     */
    int increaseInviteNum(@Param("helperId") Long helperId, @Param("type") Byte type);

    /**
     * 根据发起人id修改团队头像
     *
     * @param creator
     * @param headImg
     * @return
     */
    int updateTeamImgByCreator(@Param("creator") Long creator, @Param("headImg") String headImg);

    /**
     * 修改助力团队头像
     *
     * @param helperId
     * @param teamImg
     * @return
     */
    int updateHelpTeamImg(@Param("helperId") Long helperId, @Param("teamImg") String teamImg);

    /**
     * 创建用户邀请关系
     *
     * @param userId
     * @param inviteUserId
     * @return
     */
    int createHelpUserInvite(@Param("userId") Long userId, @Param("inviteUserId") Long inviteUserId);

    /**
     * 根据userId获取邀请人id
     *
     * @param userId
     * @return
     */
    Long getInviteUserIdByUserId(Long userId);

    /**
     * 获取用户助力时间
     *
     * @param userId
     * @return
     */
    Date getUserHelpTime(Long userId);

    /**
     * 根据时间获取助力排名(时间顺序)
     *
     * @param createTime
     * @param userId
     * @return
     */
    Integer countUserRank(@Param("createTime") Date createTime, @Param("userId") Long userId);

    List<Long> getHelpUserIdList();

    HelpUserInfo getHelpUserInfo(Long userId);

}