package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.dto.LeaderboardDTO;
import com.bxm.localnews.activity.param.PrivilegeParticipantParam;
import com.bxm.localnews.activity.vo.PrivilegeParticipantVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by Arei on 2018/10/18.
 */
@Mapper
public interface PrivilegeParticipantMapper {
    /**
     * 根据邀请人用户id查询成功邀请到的被邀请人列表
     *
     * @param privilegeParticipantParam {@link com.bxm.localnews.activity.param.PrivilegeParticipantParam}
     * @return
     */
    List<Long> listPrivilegeParticipantByInvite(PrivilegeParticipantParam privilegeParticipantParam);

    /**
     * @param privilegeId 活动id
     * @return
     */
    List<LeaderboardDTO> listLeaderboardByPrivilegeId(@Param("privilegeId") Long privilegeId);

    /**
     * 获取用户是否参与活动
     *
     * @param userId      用户id
     * @param privilegeId 活动id
     * @return
     */
    PrivilegeParticipantVO getPrivilegeParticipant(@Param("userId") Long userId, @Param("privilegeId") Long privilegeId);

    /**
     * 保存用户参与活动记录
     *
     * @param privilegeParticipantVO
     * @return
     */
    int savePrivilegeParticipant(PrivilegeParticipantVO privilegeParticipantVO);
}
