package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.Vip;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2018/12/24 17:51
 * @desc
 */
@Mapper
public interface VipMapper {

    /**
     * 根据用户id或者微信id获取vip信息
     *
     * @param userId
     * @param wechatUid
     * @return
     */
    Vip selectVipByUser(@Param("userId") Long userId, @Param("wechatUid") String wechatUid);

    /**
     * 领取vip
     *
     * @param record
     * @return
     */
    int insertSelective(Vip record);

    /**
     * 更新用户是否显示引导页
     *
     * @return
     */
    int updateUserGuide(Long userId);

    /**
     * 激活用户vip
     *
     * @param record
     * @return
     */
    int updateUserVip(Vip record);

    /**
     * 取得用户成功邀请的人数
     *
     * @param userId
     * @return
     */
    int countVipByUser(Long userId);
}
