package com.bxm.localnews.activity.service;

import java.util.Map;

import com.bxm.localnews.activity.vo.BaskInfoMeta;
import com.bxm.localnews.activity.vo.MissionModel;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.vo.Json;

/**
 * Created by Administrator on 2018/2/23.
 */
public interface MissionService {

    Json<MissionModel> listMissions(Long userId, String areaCode, String curVer);

    Json<BaskInfoMeta> baskInfo(Long userId);

    /**
     * 设置任务为完成状态
     *
     * @param userId 用户ID
     * @param taskId 任务ID{@link TaskEnum}
     * @return
     */
    void compleDailyTask(Long userId, Byte taskId);

    /**
     * 获取用户日常任务的完成情况
     *
     * @param userId 用户ID
     * @return 完成情况map，key为任务ID，value如果有值，表示已完成
     */
    Map<String, Byte> getDailyTaskStatus(Long userId);

    Long completeTask(Long userId, TaskEnum taskTypeEnum, String relationId);
}
