package com.bxm.localnews.activity.service;

import com.bxm.localnews.activity.vo.SignConfig;

import java.util.List;

public interface SignFacadeService {

    /**
     * 取得用户签到信息，如果用户没签到则进行签到
     * @param userId
     * @param platform
     * @return
     */
    com.bxm.localnews.activity.dto.SignWarper listSignRecord(Long userId, int platform);

    /**
     * 用途：获取签到的静态配置
     * 场景：在游客用户进入个人信息页面时，只能看到签到静态配置信息
     * @return
     */
    List<SignConfig> getSignConfigInfo();

    /**
     * 用途：同步用户签到排行榜
     */
    void syncSignRanking();

    /**
     * 用途：每天19点提醒昨天签到，但是今天19点还没签到的用户进行推送
     */
    void noticeUserSign();

}
