package com.bxm.localnews.activity.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "签到记录")
public class SignRecord extends BaseBean {

    @ApiModelProperty(hidden = true)
    @JSONField(serialize = false)
    private Long id;

    @ApiModelProperty(hidden = true)
    @JSONField(serialize = false)
    private Long userId;

    @ApiModelProperty(value = "签到日期", hidden = true)
    @JSONField(serialize = false)
    private Date signDate;

    @ApiModelProperty("签到天数")
    private Integer signDay;

    @ApiModelProperty("签到奖励")
    private Long signReward;

    @ApiModelProperty("是否已签到，true表示已签到")
    private Boolean signFlag;

    public SignRecord() {
    }

    public SignRecord(Long userId, Date signDate, long signReward) {
        this.userId = userId;
        this.signDate = signDate;
        this.signReward = signReward;
    }

    public Boolean getSignFlag() {
        return signFlag;
    }

    public void setSignFlag(Boolean signFlag) {
        this.signFlag = signFlag;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Date getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Integer getSignDay() {
        return this.signDay;
    }

    public void setSignDay(Integer signDay) {
        this.signDay = signDay;
    }

    public Long getSignReward() {
        return this.signReward;
    }

    public void setSignReward(Long signReward) {
        this.signReward = signReward;
    }

    public String getRewardStr() {
        return "+" + this.signReward;
    }

}