package com.bxm.localnews.activity.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by Arei on 2018/10/17.
 */
@ApiModel(description = "优惠活动列表详情")
public class PrivilegeListDTO extends BasePrivilegeDTO {

    @ApiModelProperty("活动商家所在街道名")
    private String townName = "";

    @ApiModelProperty("活动缩略图地址")
    private String thumbnailUrl;

    @ApiModelProperty("用户和商家之间的距离")
    private String distance = "";

    @ApiModelProperty("倒计时文案, 活动未开始时（status=2）显示该字段")
    private String countdown="";

    @JsonIgnore
    private Date startTime;
    @JsonIgnore
    private Double geoLat;
    @JsonIgnore
    private Double geoLng;

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Double getGeoLat() {
        return geoLat;
    }

    public void setGeoLat(Double geoLat) {
        this.geoLat = geoLat;
    }

    public Double getGeoLng() {
        return geoLng;
    }

    public void setGeoLng(Double geoLng) {
        this.geoLng = geoLng;
    }

    public String getTownName() {
        return townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getDistance() {
        return distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public String getCountdown() {
        return countdown;
    }

    public void setCountdown(String countdown) {
        this.countdown = countdown;
    }

}
