package com.bxm.localnews.activity.vo;

import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "签到结果反馈")
public class SignJson<T> extends Json {

    @ApiModelProperty("签到奖励")
    private long reward;

    private SignJson() {
    }

    private SignJson(Json<T> source) {
        super(source);
    }

    public static <T> SignJson build(Json<T> source) {
        return new SignJson<>(source);
    }

    public long getReward() {
        return reward;
    }

    public SignJson setReward(long reward) {
        this.reward = reward;
        return this;
    }

}
