package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName CommandResultVo
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/17 19:38
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/17 19:38
 **/
@ApiModel(description = "口令提交结果")
@Data
public class CommandResultDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("口令状态，0:红包已下线|1:评分少于40|2:用户领取过该红包|3:红包被领完|4:领取成功")
    private Integer status;
    @ApiModelProperty("用户名称")
    private String userName;
    @ApiModelProperty("用户头像")
    private String userImg;
    @ApiModelProperty("星级：1为1星，最高为5")
    private Integer star;
    @ApiModelProperty("评分")
    private Integer score;
    @ApiModelProperty("成绩超过用户的比例")
    private String userScale;
    @ApiModelProperty("准确率")
    private Integer matchScale;
    @ApiModelProperty("用户领取口令红包金额")
    private String userObtainAmount;
    @ApiModelProperty("新用户红包金额")
    private String newUserAmount;
    @ApiModelProperty("用时")
    private Integer length;
    @ApiModelProperty("口令最大时长")
    private Integer maxLength;
    @ApiModelProperty("口令地址")
    private String commandUrl;
    public CommandResultDTO(){
    }

    public CommandResultDTO(Integer status) {
        this.status = status;
    }
}
