package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p></p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/18
 */
@ApiModel(description = "修改红包的信息")
@Data
public class RedPacketUpdateDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("红包id")
    private Long         rpId;
    @ApiModelProperty(value = "宣传内容")
    private String       promotionContent;
    @ApiModelProperty(value = "宣传图片")
    private List<String> promotionImgs;
    @ApiModelProperty(value = "审核不通过原因")
    private String       comment;
    @ApiModelProperty(value = "口令id", required = false)
    private Long twisterId;
    @ApiModelProperty("红包口令")
    private String       content;
}
