package com.bxm.localnews.activity.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>修改口令红包参数</p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/18
 */
@ApiModel(description = "修改口令红包参数")
@Data
public class RedPacketUpdateParam {
    @ApiModelProperty(value = "红包id", required = true)
    private Long         rpId;
    @ApiModelProperty(value = "用户id", required = true)
    private Long         userId;
    @ApiModelProperty(value = "口令id", required = false)
    private Long         twisterId;
    @ApiModelProperty(value = "口令内容", required = true)
    private String       content;
    @ApiModelProperty(value = "宣传内容", required = false)
    private String       promotionContent;
    @ApiModelProperty(value = "宣传图片", required = false)
    private List<String> promotionImgs;
}
