package com.bxm.localnews.activity.vo;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 红包领取失败记录表（用户评分不满足的情况）
 * </p>
 *
 * @author JandMin
 * @since 2019-04-23
 */
public class RedPacketObtainFailedHistory implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 红包记录
     */
    private Long rpId;
    /**
     * 参与用户ID
     */
    private Long userId;
    /**
     * 录音文件地址
     */
    private String recordUrl;
    /**
     * 评分结果
     */
    private Integer score;
    /**
     * 参与时间
     */
    private Date createTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRpId() {
        return rpId;
    }

    public void setRpId(Long rpId) {
        this.rpId = rpId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getRecordUrl() {
        return recordUrl;
    }

    public void setRecordUrl(String recordUrl) {
        this.recordUrl = recordUrl;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "BRedPacketObtainFailedHistory{" +
        "id=" + id +
        ", rpId=" + rpId +
        ", userId=" + userId +
        ", recordUrl=" + recordUrl +
        ", score=" + score +
        ", createTime=" + createTime +
        "}";
    }
}
