package com.bxm.localnews.activity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

@Component
@Data
@ConfigurationProperties("activity.help.info")
public class HelpInfoProperties {

    //活动开关
    private Integer state;

    //活动区域
    private String activeArea;

    //换算比率
    private BigDecimal helpRate;

    //爱心节点
    private Integer helpPoint;

    //总助力次数限制
    private Integer helpTotalLimit;

    //活动开始时间
    private String startTime;

    //活动结束时间
    private String endTime;

    //二维码跳转地址
    private String jumpAddress;

    //助力版块id
    private Long forumId;

    //助力成功地址
    private String successAddress;

    //首页弹窗链接
    private String homeWindowUrl;

    //团队默认头像
    private String defaultTeamImg;

}
